/*
 * $Id: ldap_api_fn.h 4472 2008-07-11 19:51:40Z bogdan_iancu $
 *
 * OpenSIPS LDAP Module
 *
 * Copyright (C) 2007 University of North Carolina
 *
 * Original author: Christian Schlatter, cs@unc.edu
 *
 *
 * This file is part of opensips, a free SIP server.
 *
 * opensips is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * opensips is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * History:
 * --------
 * 2007-02-18: Initial version
 */


#ifndef LDAP_API_FN_H
#define LDAP_API_FN_H

#include <ldap.h>

#include "../../str.h"
#include "../../sr_module.h"

#define LDAP_MAX_FILTER_LEN 1024

/*
* LDAP API functions
*/
int ldap_params_search(
	int* _ld_result_count,
	char* _lds_name,
	char* _dn,
	int _scope,
	char** _attrs,
	char* _filter,
	...);

int ldap_url_search(
	char* _ldap_url,
	int* _ld_result_count);

int ldap_get_attr_vals(
	str *_attr_name,
	struct berval ***_vals);

int ldap_inc_result_pointer();

int ldap_str2scope(char* scope_str);

int get_ldap_handle(char* _lds_name, LDAP** _ldap_handle);

void get_last_ldap_result(LDAP** _last_ldap_handle, 
		LDAPMessage** _last_ldap_result);

#endif /* LDAP_API_FN_H */
